#!/bin/bash

# Train
ID="Pretrain-PHYDRL2-friction-5"
MODE='train'
CHECKPOINT=null
TEACHER_ENABLE=false
TEACHER_LEARN=false
DOMAIN_RANDOM_FRICTION_CART=true

WITH_FRICTION=true
FRICTION_CART=5
ACTUATOR_NOISE=true

RANDOM_SEED=0
TRAIN_RANDOM_RESET=true
EVAL_RANDOM_RESET=true
GAMMA=0.8

python main.py \
  general.id=${ID} \
  general.mode=${MODE} \
  general.checkpoint=${CHECKPOINT} \
  cartpole.with_friction=${WITH_FRICTION} \
  cartpole.friction_cart=${FRICTION_CART} \
  cartpole.random_reset.seed=${RANDOM_SEED} \
  cartpole.random_reset.train=${TRAIN_RANDOM_RESET} \
  cartpole.random_reset.eval=${EVAL_RANDOM_RESET} \
  cartpole.domain_random.friction_cart.apply=${DOMAIN_RANDOM_FRICTION_CART} \
  ha_teacher.teacher_enable=${TEACHER_ENABLE} \
  ha_teacher.teacher_learn=${TEACHER_LEARN} \
  hp_student.phydrl.gamma=${GAMMA}

